/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */       

#ifndef _DM388_SDMMC_
#define _DM388_SDMMC_

#define HSMMC_BASE0		0x48060000
#define HSMMC_BASE1		0x481D8000
#define TEST_PATTERN	0xAB

#define SECTOR_SIZE		(512)
#define CLK_INITSEQ    	(0)
#define CLK_400KHZ     	(1)
#define CLK_2MHZ		(2)
#define CLK_4MHZ		(3)
#define CLK_12MHZ      	(4)
#define CLK_24MHZ		(5)

#define SDMMC_REF_CLK	(192) /* 192 MHZ */

#define FAILURE			FAILED

/* Responses */
#define RSP_TYPE_NONE	(0 << 16) 
#define RSP_TYPE_R1		(2 << 16  | 1 << 19 | 1 << 20)
#define RSP_TYPE_R1B	(3 << 16  | 1 << 19 | 1 << 20)
#define RSP_TYPE_R2		(1 << 16  | 1 << 19)
#define RSP_TYPE_R3		(2 << 16)
#define RSP_TYPE_R4		(2 << 16)
#define RSP_TYPE_R5		(2 << 16)
#define RSP_TYPE_R6		(2 << 16  | 1 << 19 | 1 << 20)	
#define RSP_TYPE_R7		(2 << 16  | 1 << 19 | 1 << 20)

/* All supported commands */
#define SDMMC_CMD0		(0 << 24  | RSP_TYPE_NONE |  0 << 4)
#define SDMMC_CMD1		(1 << 24  | RSP_TYPE_R3   |  1 << 4)
#define SDMMC_CMD2		(2 << 24  | RSP_TYPE_R2   |  1 << 4)
#define SDMMC_CMD3		(3 << 24  | RSP_TYPE_R1   |  1 << 4)
#define MMC_CMD3		(3 << 24  | RSP_TYPE_R6   |  1 << 4) 
#define SDMMC_CMD4		(4 << 24  | RSP_TYPE_NONE |  1 << 4)
#define SDMMC_CMD5		(5 << 24  | RSP_TYPE_R4)
#define SDMMC_CMD6		(6 << 24  | RSP_TYPE_R1B  |  1 << 4)
#define SDMMC_CMD7		(7 << 24  | RSP_TYPE_R1B  |  1 << 4)
#define SDMMC_CMD8		(8 << 24  | RSP_TYPE_R1   |  1 << 21  | 0 << 4)
#define SDMMC_SDCMD8	(8 << 24  | RSP_TYPE_R7   |  1 << 4)
#define SDMMC_CMD9		(9 << 24  | RSP_TYPE_R2   |  1 << 4)
#define SDMMC_CMD12		(12 << 24 | RSP_TYPE_R1B  |  1 << 4)
#define SDMMC_CMD13		(13 << 24 | RSP_TYPE_R1   |  1 << 4)
#define SDMMC_CMD15		(15 << 24 | RSP_TYPE_NONE |  1 << 4)
#define SDMMC_CMD16		(16 << 24 | RSP_TYPE_R1   |  1 << 4)
#define SDMMC_CMD17		(17 << 24 | RSP_TYPE_R1   |  1 << 21 | 1 << 4)
#define SDMMC_CMD24		(24 << 24 | RSP_TYPE_R1   |  1 << 21 | 0 << 4)
#define SDMMC_ACMD6		(6  << 24 | RSP_TYPE_R1   |  1 << 4)
#define SDMMC_ACMD41	(41 << 24 | RSP_TYPE_R3   |  1 << 4)
#define SDMMC_ACMD51	(51 << 24 | RSP_TYPE_R1   |  1 << 21 | 0 << 4)
#define SDMMC_CMD55		(55 << 24 | RSP_TYPE_R1   |  1 << 4)
#define SDMMC_CMD52	 	(52 << 24 | RSP_TYPE_R5 | 1 << 4 | 1 << 21)
 

/* DM388 SDMMC Controller register defnitions */
typedef struct hsmmc {
	UINT8 res1[0x110];
	UINT32 sysconfig;
	UINT32 sysstatus;
	UINT8 res2[0x14];
	UINT32 con;
	UINT8 res3[0xD4];
	UINT32 blk;
	UINT32 arg;
	UINT32 cmd;
	UINT32 rsp10;
	UINT32 rsp32;
	UINT32 rsp54;
	UINT32 rsp76;
	UINT32 data;
	UINT32 pstate;
	UINT32 hctl;
	UINT32 sysctl;
	UINT32 stat;
	UINT32 ie;
	UINT8 res4[0x8];
	UINT32 capa;
}hsmmc_t;


/* HSMMC_STAT Defnitions */
#define STAT_CC			(1 << 0)
#define STAT_TC			(1 << 1)
#define STAT_BGE		(1 << 2)
#define STAT_BWR		(1 << 4)
#define STAT_BRR		(1 << 5)
#define STAT_CIRQ		(1 << 8)
#define STAT_OBI		(1 << 9)
#define STAT_ERRI		(1 << 15)
#define STAT_CTO		(1 << 16)
#define STAT_CCRC		(1 << 17)
#define STAT_CEB		(1 << 18)
#define STAT_CIE		(1 << 19)
#define STAT_DTO		(1 << 20)
#define STAT_DCRC		(1 << 21)
#define STAT_DEB		(1 << 22)
#define	STAT_ACE		(1 << 24)
#define STAT_CERR		(1 << 28)
#define	STAT_BADA		(1 << 29)

#define SDIO_CARD		(1)
#define SD_CARD			(2)
#define MMC_CARD		(3)
#define UNKNOWN_CARD	(-1)	

INT32 wlan_test(void *testargs);
INT32 SD_test(void *testargs);
void mmcinit (hsmmc_t *mmc_base);
INT32 detect_card(hsmmc_t *mmc_base, INT32 *is_high_cap);
INT32 get_sdio_chipid (hsmmc_t * mmc_base, UINT32 *vendor);
INT32 bread  (hsmmc_t *mmc_base, INT32 highcap, INT32 blkno, UINT32 nbytes, UINT8 *buf);
INT32 bwrite (hsmmc_t *mmc_base, INT32 highcap, INT32 blkno, UINT32 nbytes, UINT8 *buf);
INT32 platform_write(const char *fmt, ... );

#endif /* _DM388_SDMMC_ */
